// Individual entries in the linked list
public class LinkedListEntry {
	private int startAddress;	// Start address of free block
	private int endAddress;		// End address of free block
	private int size;			// Total size of free block
	private LinkedListEntry nextBlock;	// Pointer to next block in list
	private LinkedListEntry prevBlock;	// Pointer to previous block in list
	
	// Constructor
	public LinkedListEntry(int start, int end, int size){
		this.startAddress = start;
		this.endAddress = end;
		this.size = size;
		setNextBlock(null);
		setPrevBlock(null);
	}
	
	public int getStartAddress() {
		return startAddress;
	}
	
	public int getEndAddress() {
		return endAddress;
	}
	
	public int getSize() {
		return size;
	}
	
	public LinkedListEntry getNextBlock() {
		return nextBlock;
	}
	
	public void setNextBlock(LinkedListEntry nextBlock) {
		this.nextBlock = nextBlock;
	}

	public LinkedListEntry getPrevBlock() {
		return prevBlock;
	}
	
	public void setPrevBlock(LinkedListEntry prevBlock) {
		this.prevBlock = prevBlock;
	}
	
}
